<?php

namespace App\View\Components;

use SEOMeta;
use OpenGraph;
use TwitterCard;
use App\Models\WebConfiguration;
use Illuminate\View\Component;
use Illuminate\Support\Facades\Schema;

class UserLayout extends Component
{
    public function render()
    {
        if (Schema::hasTable('web_configurations')) {
            config([
                'settings' => WebConfiguration::all(['meta_key', 'meta_value'])->keyBy('meta_key')->transform(function($config){ return $config->meta_value; })->toArray()
            ]);
        }

        SEOMeta::setTitle( config('settings.site-name') );
        SEOMeta::setDescription( config('settings.site-description') );
        SEOMeta::setKeywords([ 'test', 'test again' ]);
        SEOMeta::addMeta( 'language', 'ID' );

        OpenGraph::setTitle( config('settings.site-name') );
        OpenGraph::setDescription( config('settings.site-description') );
        OpenGraph::setUrl( config('settings.site-url') );
        OpenGraph::addProperty( 'type', 'article' );
        OpenGraph::addProperty( 'locale', 'id-ID' );

        return view('user.layouts.app');
    }
}
