<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use App\Models\WebConfiguration;
use App\Models\Spin;
use App\Models\Ticket;
use App\Models\Member;
use Illuminate\Http\Request;
use Artesaos\SEOTools\Facades\SEOMeta;

class WebConfigurationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Web Configuration';
        $page_description = 'This is Web Configuration test page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Web Configuration']
        ];
        
        $sitename = WebConfiguration::where(['meta_key' => 'site-name'])->first();
        $sitekeyword = WebConfiguration::where(['meta_key' => 'site-keywords'])->first();
        $sitedescription = WebConfiguration::where(['meta_key' => 'site-description'])->first();
        $sitelogo = WebConfiguration::where(['meta_key' => 'logo'])->first();
        $sitefavicon = WebConfiguration::where(['meta_key' => 'favicon'])->first();
        $sitebgcolor = WebConfiguration::where(['meta_key' => 'background-color'])->first();
        $sitebgimage = WebConfiguration::where(['meta_key' => 'background-image'])->first();
        $sitelandingtable = WebConfiguration::where(['meta_key' => 'landing-table'])->first();
        $sitelandingusername = WebConfiguration::where(['meta_key' => 'landing-username'])->first();
        $sitebgspin = WebConfiguration::where(['meta_key' => 'bg-spin'])->first();
        $siterewardcolor = WebConfiguration::where(['meta_key' => 'reward-color'])->first();
        $sitegradient1 = WebConfiguration::where(['meta_key' => 'gradient1'])->first();
        $sitegradient2 = WebConfiguration::where(['meta_key' => 'gradient2'])->first();
        $siterewardtext = WebConfiguration::where(['meta_key' => 'reward-text'])->first();
        $sitewelcometext = WebConfiguration::where(['meta_key' => 'welcome-text'])->first();
        $sitewelcometitle = WebConfiguration::where(['meta_key' => 'welcome-title'])->first();
        $sitemaintenance = WebConfiguration::where(['meta_key' => 'maintenance'])->first();
        $sitebgimagemobile = WebConfiguration::where(['meta_key' => 'background-mobile'])->first();
         
        

        
        return view('pages.cms.config.index', compact('page_title', 'page_description', 'page_breadcrumbs', 'sitemaintenance', 'sitewelcometext', 'sitewelcometitle', 'siterewardtext', 'sitegradient1', 'sitegradient2', 'siterewardcolor', 'sitebgspin', 'sitename', 'sitekeyword', 'sitedescription', 'sitelogo', 'sitefavicon', 'sitebgcolor', 'sitebgimage', 'sitelandingtable', 'sitelandingusername', 'sitebgimagemobile'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        if ($request->hasFile('web_logo')) {
            $request->web_logo->storeAs('media/logos', 'logo.'.$request->web_logo->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'logo'])->update([
                'meta_value' => 'storage/media/logos/logo.'.$request->web_logo->guessExtension(),
            ]);
        }

        if ($request->hasFile('web_favicon')) {
            $request->web_favicon->storeAs('media/logos', 'favicon.'.$request->web_favicon->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'favicon'])->update([
                'meta_value' => 'storage/media/logos/favicon.'.$request->web_favicon->guessExtension(),
            ]);
        }

        if ($request->hasFile('web_bg_image')) {
            $request->web_bg_image->storeAs('media/logos', 'bg.'.$request->web_bg_image->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'background-image'])->update([
                'meta_value' => 'storage/media/logos/bg.'.$request->web_bg_image->guessExtension(),
            ]);
        }

        if ($request->hasFile('web_bg_image_mobile')) {
            $request->web_bg_image_mobile->storeAs('media/logos', 'bg-mobile.'.$request->web_bg_image_mobile->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'background-mobile'])->update([
                'meta_value' => 'storage/media/logos/bg-mobile.'.$request->web_bg_image_mobile->guessExtension(),
            ]);
        }
        

        if ($request->hasFile('bg_spin')) {
            $request->bg_spin->storeAs('media/logos', 'bg_spin.'.$request->bg_spin->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'bg-spin'])->update([
                'meta_value' => 'storage/media/logos/bg_spin.'.$request->bg_spin->guessExtension(),
            ]);
        }

        if ($request->hasFile('bg_audio')) {
            $request->bg_audio->storeAs('media/audio', 'bg_audio.'.$request->bg_audio->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'bg-audio'])->update([
                'meta_value' => 'storage/media/audio/bg_audio.'.$request->bg_audio->guessExtension(),
            ]);
        }

        if ($request->hasFile('winner_audio')) {
            $request->winner_audio->storeAs('media/audio', 'winner_audio.'.$request->winner_audio->guessExtension(), 'public');
            WebConfiguration::where(['meta_key' => 'winner-audio'])->update([
                'meta_value' => 'storage/media/audio/winner_audio.'.$request->winner_audio->guessExtension(),
            ]);
        }
        

        WebConfiguration::where(['meta_key' => 'site-name'])->update([
            'meta_value' => $request->web_title,
        ]);
        
        WebConfiguration::where(['meta_key' => 'site-keywords'])->update([
            'meta_value' => $request->web_keywords,
        ]);

        WebConfiguration::where(['meta_key' => 'site-description'])->update([
            'meta_value' => $request->web_description,
        ]);

        WebConfiguration::where(['meta_key' => 'background-color'])->update([
            'meta_value' => $request->web_bg_color,
        ]);

        WebConfiguration::where(['meta_key' => 'landing-table'])->update([
            'meta_value' => $request->landing_table,
        ]);

        WebConfiguration::where(['meta_key' => 'landing-username'])->update([
            'meta_value' => $request->landing_username,
        ]);

        WebConfiguration::where(['meta_key' => 'reward-color'])->update([
            'meta_value' => $request->reward_color,
        ]);
        
        WebConfiguration::where(['meta_key' => 'gradient1'])->update([
            'meta_value' => $request->gradient1,
        ]);
        
        WebConfiguration::where(['meta_key' => 'gradient2'])->update([
            'meta_value' => $request->gradient2,
        ]);

        WebConfiguration::where(['meta_key' => 'reward-text'])->update([
            'meta_value' => $request->reward_text,
        ]);
        
        WebConfiguration::where(['meta_key' => 'welcome-text'])->update([
            'meta_value' => $request->welcome_text,
        ]);
        
        WebConfiguration::where(['meta_key' => 'welcome-title'])->update([
            'meta_value' => $request->welcome_title,
        ]);

        WebConfiguration::where(['meta_key' => 'maintenance'])->update([
            'meta_value' => $request->maintenance,
        ]);
        

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\WebConfiguration  $webConfiguration
     * @return \Illuminate\Http\Response
     */
    public function show(WebConfiguration $webConfiguration)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\WebConfiguration  $webConfiguration
     * @return \Illuminate\Http\Response
     */
    public function edit(WebConfiguration $webConfiguration)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\WebConfiguration  $webConfiguration
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, WebConfiguration $webConfiguration)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\WebConfiguration  $webConfiguration
     * @return \Illuminate\Http\Response
     */
    public function destroy(WebConfiguration $webConfiguration)
    {
        //
    }

    public function clearAll(){
        Spin::truncate();
        Member::truncate();
        Ticket::truncate();
    }
}
