<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;
use App\Helpers\Helper;

use App\Models\{Branch, Bank};

class SummaryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Summary';
        $page_description = 'This is Summary Report';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Summary'],
            ['page' => 'summary', 'title' => 'Summary Report']
        ];
        $branches = Branch::all();
        $banks = Bank::all();
        $types = DB::table('bank_types')->get();
        return view('pages.summary.index', compact('branches', 'banks', 'types', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $res = '';
        $dtfrom = $request->df;
        $dtto = $request->dt;
        $branch = $request->br;
        $bank = $request->bn;
        $type = $request->tp;

        $data = DB::table('accounts')
            ->join('banks', 'banks.idbank', '=', 'accounts.idbank')
            ->select('accounts.*', 'banks.bankcode')
            ->where('accounts.isactive', '=', 1);

        if ($branch != '') {
            $res = $data->where('accounts.idbranch', '=', $branch)
                ->get();
        }
        if ($bank != '') {
            $res = $data->where('accounts.idbank', '=', $bank)
                ->get();
        }
        if ($type != '') {
            $res = $data->where('accounts.acctype', '=', $type)
                ->get();
        }
        if ($dtfrom != '' && $dtto != '') {
            $res = $data->get();
        }

        $i = 0;
        $array = array();
        foreach ($res as $item) {
            if ($dtfrom != '' && $dtto != '') {
                $opening = @Helper::checkBalance($item->idacc, 'opening');
                $totalin = Helper::sumTransaction($item->idacc, 'DB', $dtfrom, $dtto, 'amount');
                $totalout = Helper::sumTransaction($item->idacc, 'CR', $dtfrom, $dtto, 'amount');
                $totalfee = Helper::sumTransaction($item->idacc, 'CR', $dtfrom, $dtto, 'fee');
                $balance = $opening + $totalin - ($totalout + $totalfee);
            }

            $i++;
            $array[] = array(
                'no' => $i,
                'accname' => $item->accname . ' - ' . $item->accno,
                'bank' => $item->bankcode,
                'type' => $item->acctype,
                'opening' => number_format($opening),
                'totalin' => number_format($totalin),
                'totalout' => number_format($totalout),
                'totalfee' => number_format($totalfee),
                'balance' => number_format($balance),
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
