<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;
use Auth;

use App\Models\Sidebar;
use App\Models\Detail;

class SidebarController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Sidebar';
        $page_description = 'This is Sidebar page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Sidebar'],
            ['page' => 'sidebar-menu', 'title' => 'Sidebar Menu']
        ];
        return view('pages.sidebar.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page_title = 'Create Sidebar-menu';
        $page_description = 'This is Create Sidebar-menu page';
        $data = Sidebar::all();
        return view('pages.sidebar.create', compact('data', 'page_title', 'page_description'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'parent' => 'required|max:255',
            'title' => 'required|max:255',
            'slug' => 'required|max:255',
            'root' => 'required|max:255',
            'icon' => 'required|max:255',
            'page' => 'required|max:255',
            'newtab' => 'required|max:255',
            'mnheader' =>  'required|max:255',
            'mnorder' => 'required|max:255',
            'isactive' => 'required|max:255'
        ]);
        Sidebar::create([
            'parent' => $request->parent,
            'title' => $request->title,
            'slug' => $request->slug,
            'root' => $request->root,
            'icon' => $request->icon,
            'page' => $request->page,
            'newtab' => $request->page,
            'mnheader' =>  $request->mnheader,
            'mnorder' => $request->mnorder,
            'isactive' => $request->isactive,
        ]);
        
        Helper::Activity('sidebar-menu', '', 'CREATE ' . $request->title);
        Alert::success('Success!', 'Data has been saved!');
        return redirect('sidebar-menu');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Sidebar  $sidebar
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $sidebar = DB::table('menus')->get();
        $i = 0;
        $array = array();
        foreach ($sidebar as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'id' => $data->id,
                'parent' => $data->parent,
                'title' => $data->title,
                'slug' => $data->slug,
                'root' => $data->root,
                'icon' => $data->icon,
                'page' => $data->page,
                'newtab' => $data->page,
                'mnheader' =>  $data->mnheader,
                'mnorder' => $data->mnorder,
                'isactive' => $data->isactive,
                'created_at' => $data->created_at,
                'updated_at' => $data->updated_at
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Sidebar  $sidebar
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'Edit Sidebar';
        $page_description = 'This is SIdebar test page';
        $data = Sidebar::find($id);
        $parrent = Sidebar::all();
        return view('pages.sidebar.edit', compact('page_title', 'page_description', 'data', 'parrent'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Sidebar  $sidebar
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Sidebar::find($id)
            ->update([
                'parent' => $request->parent,
                'title' => $request->title,
                'slug' => $request->slug,
                'root' => $request->root,
                'icon' => $request->icon,
                'page' => $request->page,
                'newtab' => $request->page,
                'mnheader' =>  $request->mnheader,
                'mnorder' => $request->mnorder,
                'isactive' => $request->isactive,
            ]);
        Helper::Activity('sidebar-menu', $id, 'UPDATE ' . $request->title);
        Alert::success('Success!', 'Data has been update!');
        return redirect('sidebar-menu');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Sidebar  $sidebar
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('sidebar-menu', $id, 'DELETE');
        Sidebar::find($id)->delete();
    }

    public function icon()
    {
        return view('pages.sidebar.icon');
    }
}
