<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;

use App\Models\Setting;
use App\Models\TransactionSetting;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Setting';
        $page_description = 'This is Setting test page';
        $page_breadcrumbs = [
            ['page' => 'login-history', 'title' => 'Users'],
            ['page' => 'login-history', 'title' => 'History Login']
        ];
        return view('pages.setting.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('pages.setting.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'optname' => 'required|max:255',
            'optvalue' => 'required|max:255',
            'isactive' => 'required',
        ]);
        if ($validator->fails()) {
            Alert::warning('Oops!', 'Something When Wrong!');
            return redirect('general-setting')->withErrors($validator);
        } else {
            setting::create([
                'optname' => $request->optname,
                'optvalue' => $request->optvalue,
                'isactive' => $request->isactive,
            ]);
            Helper::Activity('general-setting', '', 'CREATE ' . strtoupper($request->optname));
            Alert::success('Success!', 'Data Has Been Saved!');
            return redirect('general-setting');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $settings = DB::table('settings')->get();
        $i = 0;
        $array = array();
        foreach ($settings as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'id' => $data->id,
                'optname' => $data->optname,
                'optvalue' => $data->optvalue,
                'isactive' => $data->isactive,
                'created_at' => $data->created_at,
                'updated_at' => $data->updated_at
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Setting::find($id);
        return view('pages.setting.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Setting::find($id)
            ->update([
                'optname' => $request->optname,
                'optvalue' => $request->optvalue,
                'isactive' => $request->isactive,
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        Helper::Activity('general-setting', $id, 'UPDATE ' . strtoupper($request->optname));
        Alert::success('Success!', 'Data has been update!');
        return redirect('general-setting');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('general-setting', $id, 'DELETE');
        setting::find($id)->delete();
    }

    public function transactionSetting()
    {
        $transactionSetting = TransactionSetting::get()->all();
        return view('pages.transaction-setting.index', compact('transactionSetting'));
    }

    public function transactionSettingDeposit(Request $request)
    {
        if($request->jumlah_deposit){
            TransactionSetting::where(['id' => 2])->update([
                'value' => str_replace('.', '', $request->jumlah_deposit),
            ]);
        }
        return redirect()->back();
    }

    public function transactionSettingWithdrawl(Request $request)
    {
        if($request->jumlah_withdrawl){
            TransactionSetting::where(['id' => 1])->update([
                'value' => str_replace('.', '', $request->jumlah_withdrawl),
            ]);
        }
        return redirect()->back();
    }
    
}
