<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Auth;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;

use App\Models\OpenMemo;
use App\Models\Member;
use App\Models\MemoAccess;

class OpenMemoController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Open Memo';
        $page_description = 'This is Open Memo Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Open Memo'],
            ['page' => 'open_memo', 'title' => 'Open Memo Product']
        ];
        return view('pages.memo-open.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page_title = 'Add Open Memo';
        $page_description = 'This is Add Open Memo Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Open Memo'],
            ['page' => 'Open Memo', 'title' => 'Add Open Memo Branch']
        ];
        $members = Member::get();
        return view('pages.memo-open.create', compact('page_title', 'page_description', 'page_breadcrumbs', 'members'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'memo' => 'required',
            'type' => 'required'
        ]);
        if ($validator->fails()) {
            Alert::warning('Oops!', 'Something When Wrong!');
            return redirect('open-memo')->withErrors($validator);
        } else {
            $affected = OpenMemo::create([
                'subject' => $request->subject,
                'memo' => $request->memo,
                'type' => $request->type,
            ]);

            

            $dataSet = [];
            foreach ($request->memo_access as $member_access) {
                $dataSet[] = [
                    'idmemo' => $affected->id,
                    'idmember' => $member_access,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
            }

            $insertAccess = MemoAccess::insert($dataSet);

            if ($affected) {
                Helper::Activity('open-memo', $affected->id, 'CREATE');
                Alert::success('Success!', 'Data Has Been Saved!');
                return redirect('open-memo');
            } else {
                Alert::success('Error!', 'Something When Wrong!');
                return redirect('open-memo');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OpenMemo  $OpenMemo
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $res = '';
        $query = $request->qr;
        $dtfrom = $request->df;
        $dtto = $request->dt;

        $result = OpenMemo::orderByDesc('created_at');

        if ($query != '') {
            $res = $result->get();
        }
        if ($dtfrom != '' && $dtto != '') {
            $res = $result->get();
        }

        $i = 0;
        $array = array();
        foreach ($res as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'subject' => $data->subject,
                'memo' => $data->memo,
                'type' => $data->type,
                'id' => $data->id,
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OpenMemo  $OpenMemo
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'Edit Open Memo';
        $page_description = 'This is Edit Open Memo Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Open Memo'],
            ['page' => 'Open Memo', 'title' => 'Edit Open Memo Bank']
        ];
        $open_memo = OpenMemo::find($id);
        return view('pages.memo-open.edit', compact('open_memo', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OpenMemo  $OpenMemo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $affected = OpenMemo::find($id)
            ->update([
                'subject' => $request->subject,
                'memo' => $request->memo,
                'type' => $request->type,
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        if ($affected) {
            Helper::Activity('open-memo', $id, 'UPDATE');
            Alert::success('Success!', 'Data has been update!');
            return redirect('open-memo');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OpenMemo  $OpenMemo
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('open-memo', $id, 'DELETE');
        OpenMemo::find($id)->delete();
    }
}
