<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Auth;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;

use App\Models\Memo;

class MemoController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Memo';
        $page_description = 'This is Memo Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Memo'],
            ['page' => 'memos', 'title' => 'Memo Product']
        ];
        return view('pages.memo.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page_title = 'Add Memo';
        $page_description = 'This is Add Memo Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Memo'],
            ['page' => 'Memo', 'title' => 'Add Memo Branch']
        ];
        return view('pages.memo.create', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Memo  $Memo
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $res = '';
        $query = $request->qr;
        $dtfrom = $request->df;
        $dtto = $request->dt;

        $result = DB::table('memos')->where('type', '=', 'sent')->orderByDesc('memos.created_at');

        if ($query != '') {
            $res = $result->get();
        }
        if ($dtfrom != '' && $dtto != '') {
            $res = $result->get();
        }

        $i = 0;
        $array = array();
        foreach ($res as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'idmember' => $data->idmember,
                'subject' => $data->subject,
                'text_sent' => $data->text_sent,
                'id' => $data->id,
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Memo  $Memo
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'Edit Memo';
        $page_description = 'This is Edit Memo Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Memo'],
            ['page' => 'Memo', 'title' => 'Edit Memo Bank']
        ];
        $memo = Memo::find($id);
        return view('pages.memo.edit', compact('memo', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Memo  $Memo
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $id = IdGenerator::generate(['table' => 'memos', 'field' => 'idmemo', 'length' => 13, 'prefix' => 'MEMO' . date('m')]);
        $newTextSent = $request->text_inbox."<br/> ______________________<br/>".$request->text_sent;
        $affected = Memo::create([
            'idmemo' => $id,
            'idmember' => $request->idmember,
            'subject' => $request->subject,
            'text_inbox' => $newTextSent,
            'text_sent' => '-',
            'type' => 'inbox'
        ]);
        if ($affected) {
            Helper::Activity('memos', $id, 'CREATE');
            Alert::success('Success!', 'Data Has Been Saved!');
            return redirect('memos');
        } else {
            Alert::success('Error!', 'Something When Wrong!');
            return redirect('memos');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Memo  $Memo
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('memos', $id, 'DELETE');
        Memo::find($id)->delete();
    }
}
