<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;

use App\Models\Version;

class LogController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Log Information';
        $page_description = 'This is Log Information page';
        $data = Version::orderByDesc('created_at')->get();
        return view('pages.log.index', compact('page_title', 'page_description', 'data'));
    }
}
