<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;
use App\Helpers\Helper;

use App\Models\Branch;

class AuditController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Audit';
        $page_description = 'This is Audit Page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Audit'],
            ['page' => 'audit', 'title' => 'Audit Bank']
        ];
        $branches = Branch::all();
        return view('pages.audit.index', compact('branches', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $dtfrom = $request->df;
        $dtto = $request->dt;
        $keyword = $request->qr;
        $branch = $request->br;

        $transaction = DB::table('transactions')
            ->join('branches', 'branches.idbranch', '=', 'transactions.idbranch')
            ->leftjoin('products', 'products.idproduct', '=', 'transactions.idproduct')
            ->leftjoin('members', 'members.idmember', '=', 'transactions.idmember')
            ->leftjoin('accounts', 'accounts.idacc', '=', 'transactions.idacc')
            ->join('users', 'users.iduser', '=', 'transactions.iduser')
            ->select(
                'transactions.*',
                'branches.branchname',
                'products.productname',
                'members.mbraccname',
                'accounts.accname',
                'users.username',
            );
        if ($branch != '') {
            $res = $transaction->where('transactions.trcstatus', '=', 'CONFIRM')
                ->where('transactions.idbranch', '=', $branch)
                ->get();
        }
        if ($keyword != '') {
            $res = $transaction->where('transactions.trcstatus', '=', 'CONFIRM')
                ->where('accounts.idacc', '=', $keyword)
                ->get();
        }
        if ($dtfrom != '' && $dtto != '') {
            $res = $transaction->where('transactions.trcstatus', '=', 'CONFIRM')
                ->whereBetween(DB::raw('LEFT(transactions.datetrc,10)'), [$dtfrom, $dtto])
                ->get();
        }

        $i = 0;
        $array = array();
        $opening = @Helper::checkBalance($keyword, 'opening');
        $coin = @Helper::checkCoin($branch, 'opening');
        $array[] = array(
            'no' => '#',
            'datetrc' => @Helper::checkBalance($keyword, 'dtopening'),
            'description' => 'OPENING BALANCE',
            'type' => 'OPENING',
            'debet' => number_format(0),
            'credit' => number_format(0),
            'fee' => number_format(0),
            'bbalance' => number_format($opening),
            'bonus' => number_format(0),
            'cbalance' => number_format($coin),
            'user' => strtoupper(''),
        );
        foreach ($res as $data) {
            $i++;
            if ($data->dttype == 'DB') {
                $debet = $data->amount;
                $credit = 0;
                $fee = 0;
                $bonus = 0;
                $opening = $opening + $debet;
            } else if ($data->dttype == 'CR') {
                $debet = 0;
                $credit = $data->amount;
                $fee = $data->fee;
                $bonus = 0;
                $opening = $opening - ($credit + $fee);
            } else if ($data->dttype == '-' && $data->trctype == 'BONUS') {
                $debet = 0;
                $credit = 0;
                $fee = 0;
                $bonus = $data->coin;
                $opening = $opening;
            }

            if ($data->dttype == 'DB' && $data->trctype == 'DEPOSIT') {
                $coin = $coin - $data->amount;
            } else if ($data->dttype == 'CR' && $data->trctype == 'WITHDRAWAL') {
                $coin = $coin + $data->amount;
            } else if ($data->dttype == '-' && $data->trctype == 'BONUS') {
                $coin = $coin - $data->coin;
            }

            if ($data->trctype == 'DEPOSIT') {
                $description = $data->mbraccname;
            } else if ($data->trctype == 'WITHDRAWAL') {
                $description = $data->mbraccname;
            } else if ($data->trctype == 'TRANSFER') {
                if ($data->dttype == 'CR') {
                    $description = 'TRANSFER TO : ' . Helper::getTransfer($data->note, 'DB');
                } else if ($data->dttype == 'DB') {
                    $description = 'TRANSFER FROM : ' . Helper::getTransfer($data->note, 'CR');
                }
            } else if ($data->trctype == 'BONUS') {
                $description = $data->mbraccname;
            } else if ($data->trctype == 'OTHER') {
                $description = $data->remark;
            }

            $closing = $opening;
            $clscoin = $coin;
            $date = date_create($data->datetrc);
            $array[] = array(
                'no' => $i,
                'datetrc' => date_format($date, 'Y-m-d'),
                'description' => strtoupper($description),
                'type' => $data->trctype,
                'debet' => @number_format($debet),
                'credit' => @number_format($credit),
                'fee' => @number_format($fee),
                'bbalance' => number_format($closing),
                'bonus' => number_format($bonus),
                'cbalance' => number_format($clscoin),
                'user' => strtoupper($data->username)
            );
        }
        $array[] = array(
            'no' => 'Z',
            'datetrc' => @Helper::checkBalance($keyword, 'dtopening'),
            'description' => 'CLOSING BALANCE',
            'type' => 'CLOSING',
            'debet' => number_format(0),
            'credit' => number_format(0),
            'fee' => number_format(0),
            'bbalance' => number_format($opening),
            'bonus' => number_format(0),
            'cbalance' => number_format($coin),
            'user' => strtoupper(''),
        );
        return Datatables::of($array)->make(true);
    }
}
