<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use App\Models\Activity;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;

class ActivityController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Activities';
        $page_description = 'This is Activities Page';
        $page_breadcrumbs = [
            ['page' => 'activitys', 'title' => 'Users'],
            ['page' => 'activitys', 'title' => 'Activities']
        ];
        return view('pages.activity.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $res = '';
        $query = $request->qr;
        $dtfrom = $request->df;
        $dtto = $request->dt;
        $result = DB::table('activities')
            ->join('users', 'activities.iduser', '=', 'users.iduser')
            ->join('menus', 'activities.idmenu', '=', 'menus.id')
            ->select('activities.*', 'users.username', 'menus.title');
        if ($query != null) {
            $res = $result->where(function ($where) use ($query) {
                $where->orWhere('activities.idtrc', 'LIKE', '%' . $query . '%')
                    ->orWhere('activities.iduser', 'LIKE', '%' . $query . '%')
                    ->orWhere('activities.description', 'LIKE', '%' . $query . '%')
                    ->orWhere('users.username', 'LIKE', '%' . $query . '%');
            })->get();
        }
        if ($dtfrom != null and $dtto != null) {
            $res = $result->whereBetween(DB::raw('LEFT(activities.created_at,10)'), [$dtfrom, $dtto])->get();
        }

        $i = 0;
        $array = array();
        foreach ($res as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'username' => strtoupper($data->username),
                'menu' => strtoupper($data->title),
                'idtrc' => $data->idtrc,
                'description' => strtoupper($data->description . ' NEW ' . $data->title . ' ' . $data->idtrc),
                'created_at' => $data->created_at,
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function edit(Activity $activity)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Activity $activity)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function destroy(Activity $activity)
    {
        //
    }
}
