<!DOCTYPE html>
<html lang="en">
<head>
  <title>{{Fibonanci::content()['name']}}</title>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="msapplication-TileImage" content="{{url('assets/wheel/img/favicon.ico/ms-icon-144x144.png')}}">

  @include('web.css')

  <style>
    .wheelText {
    font-size: 16px;
    font-family: 'Prompt', sans-serif;
    font-weight:900;
    text-align: center;
    color: aqua
  }
  
  .btn-back{
      font-size: 22px;
      width: 100%;
      background: linear-gradient(to bottom, #02abff 16%, #02abff 44%, #02abff 99%);
      color:rgb(0, 0, 0);
      padding: 5px 15px;
      border:0px;
      box-shadow: 2px 2px 2px grey;
      border-radius: 30px;
      font-weight: bolder;
  }
  
  button.submit {
      font-size: 22px;
      width: 100%;
      background: linear-gradient(to bottom, #ecad00 16%, #ffd563 44%, #ecad00 99%);
      color:rgb(0, 0, 0);
      padding: 5px 15px;
      border:0px;
      box-shadow: 2px 2px 2px grey;
      border-radius: 30px;
  }
  
  input.submit {
      font-size: 22px;
      width: 100%;
      background: linear-gradient(to bottom, #ecad00 16%, #ffd563 44%, #ecad00 99%);
      color:rgb(0, 0, 0);
      padding: 5px 15px;
      border:0px;
      box-shadow: 2px 2px 2px grey;
      border-radius: 30px;
      font-weight: bolder;
  }
  
  .popup-container{
      width: 100%;
      height: 100%;
      position: fixed;
      z-index: 1000;
      background: #080808b0;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
  }
  
  .popup-body{
      width: 347px;
      height: 600px;
      margin: 2% auto;
      background: #313131;
      border-radius: 0px;
      color: white;
  }
  
  @media (max-width: 992px){
      .popup-body{
          margin: 10% auto;
      }
  }
  
  @media (max-width: 768px){
    .logo-pc{
        display:none!important;
    }
  
    .logo-mobile{
      display:block!important;
      width: 80%;
      margin-top: 10px;
    }
  }
  
  @media (min-width: 769px){
    .logo-pc{
        display:block!important;
    }
  
    .max-c{
      margin:0px!important;
      padding:0px!important;
    }
  
    .logo-mobile{
      display:none!important;
    }
  }
  
  
  .popup-header{
      height: 48px;
      width: 100%;
      background: #754116;
      float: left;
  }
  
  .popup-close{
      cursor: pointer;
      width: 36px;
      height: 36px;
      background: white;
      color: black;
      float: right;
      padding: 5px;
      border-radius: 100px;
      position: absolute;
      margin-top: -10px;
      margin-left: -9px;
  }
  
  .popup-container-ads{
      background-repeat: no-repeat;
      margin: 10% auto;
      border-radius: 18px;
      background-size: 100%;
  }

  #headerTitle {
    text-shadow: -7px 4px 11px #000000;
    color: #FFFFFF;
}
  </style>

  <body style="background-image: url('{{Fibonanci::content()['background']}}'); 
  background-position: center; background-size: cover; 
  background-repeat: no-repeat; background-color: 
  black;background-attachment: fixed;">

</head>

<body class="text-center" onload="zoom()">

<div class="container">
    <div class="row h-100 mx-auto" style="height:100%!important">
        <a href="{{url('/')}}" style="margin-bottom: 10px">

            <img alt="Voucher Wheel logo" class="mx-auto d-block img-fluid logo-mobile" src="{{Fibonanci::content()['logo']}}">

        </a>
        <!-- Wheel -->
        <div class="col-sm-7 my-auto" style="padding:0px">
            <div class="row no-gutters no-border rounded overflow-hidden flex-md-row mb-4 shadow-sm h-md-250 position-relative">
            <div class="col d-flex flex-column position-static">
                <div id="chart"></div>
            </div>
            </div>
        </div>

        <!-- Form -->
        <div class="col-sm-5 my-auto">
            <div class="row no-gutters no-border rounded overflow-hidden flex-md-row mb-4 ml-4 mr-4 shadow-sm h-md-250 position-relative">
            <div class="container">
            <a href="{{url('/')}}">
                <img alt="Voucher Wheel logo" class="mx-auto d-block img-fluid logo-pc" src="{{Fibonanci::content()['logo']}}">
            </a>
            
            @yield('content')
            
            </div>
        </div>
    </div>
</div>

</div>

@include('web.js')

@stack('js')

</body>
</html>


