@extends('template.content')
@section('content')


  <div class="row justify-content-md-center">
    <div class="col-md-6 col-sm-12 grid-margin stretch-card">
      <div class="card" style="max-height:300px">
        <div class="card-body">
          <h4 class="card-title">Create {{$title}}</h4>
          <form class="forms-sample" method="POST" action="{{url('admin/member/store')}}">
            @csrf
            <div class="mb-3">
                <div class="form-group">
                    <label for="username">username</label>
                    <input type="text" class="form-control" id="username" name="username" placeholder="username" autofocus>
                </div>
                
            </div>
            <button type="submit" class="btn btn-sm btn-primary me-2">Tambah Data</button>
          </form>
        </div>
      </div>
    </div>
  </div>

    <div class="row">
        <div class="col-sm-12">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">{{$title}}</h4>
                    <div class="table-responsive">
                      <table class="table" id="tabel">
                        <thead>
                          <tr>
                            <th>username</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          @foreach($row as $key)
                          <tr>
                            <td>{{$key->username}}</td>
                            <td>
                                <button type="button" class="btn btn-warning btn-rounded btn-icon" 
                                data-bs-toggle="modal" data-bs-target="#edit{{$key->id}}">
                                    edit
                                </button>
                                <a href="javascript:void(0)" onclick="hapus('{{url('admin/member/destroy/'.$key->id)}}')" class="btn btn-sm btn-danger">delete</a>
                            </td>
                          </tr>

                          <div class="modal fade" id="edit{{$key->id}}" tabindex="-1" aria-labelledby="create" aria-hidden="true">
                            <div class="modal-dialog">
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h1 class="modal-title fs-5" id="exampleModalLabel">Modal title</h1>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                        
                                <form action="{{url('admin/member/update')}}" method="POST">
                                    @csrf

                                    <input type="hidden" value="{{$key->id}}" name="id">
                        
                                <div class="modal-body">

                                  <div class="form-group">
                                    <label for="username">username</label>
                                    <input type="text" class="form-control" id="username" value="{{$key->username}}" name="username" placeholder="username">
                                  </div>
       
                                </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                  <button type="submit" class="btn btn-primary">Update changes</button>
                                </div>
                        
                                </form>
                        
                        
                              </div>
                            </div>
                          </div>


                          @endforeach
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
        </div>
    </div>


@push('js')
    <script>
      $(document).ready( function () {
        $('#tabel').DataTable({
          "pageLength": 25,
             searching: true,
             ordering:  true,
             paging: true,   
             "order": [[1, 'desc']],
             "columnDefs": [
                { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
              ],     
        });
    });
    </script>

    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
        });
    </script>
@endpush

@endsection