@extends('template.content')
@section('content')

    <div class="row">
        <div class="col-sm-12 grid-margin stretch-card">
          <div class="card">
            <div class="card-body">
              <h4 class="card-title">{{$title}}</h4>
              <p class="card-description"> {{$subtitle}} </p>
              <form class="forms-sample" method="POST" action="{{url('admin/draw/update')}}" enctype="multipart/form-data">
                @csrf
                <input type="hidden" value="{{$row->id}}" name="id">
                <div class="form-group">
                    <label for="type">type</label>
                    <select class="form-control" name="type" id="type" required>
                        <option value="{{$row->type}}" selected>{{$row->type}}</option>
                      <option value="presentase">presentase</option>
                      <option value="select prize">select prize</option>
                    </select>
                  </div>
                  
                <div class="form-group">
                    <label for="prize_id">Prize</label>
                    <select class="form-control" name="prize_id" id="prize_id" required>
                     <option value="" selected>pilih hadiah</option>
                     <option value="{{$row->prize_id}}" selected>{{$row->prize}}</option>
                      @foreach($prize as $priz)
                        <option value="{{$priz->id}}">{{$priz->label}}</option>
                      @endforeach
                    </select>
                  </div>
                  <div class="form-group">
                    <label for="voucher_id">Voucher / Code</label>
                    <select class="form-control" name="voucher_id" id="voucher_id" required>
                        <option value="{{$row->voucher_id}}" selected>{{$row->voucher}} - {{$row->member}}</option>
                      @foreach($voucher as $voc)
                        <option value="{{$voc->id}}">{{$voc->voucher}} - {{$voc->member}}</option>
                      @endforeach
                    </select>
                  </div>

                  <div class="form-group">
                    <label for="users" class="form-label">status</label>
                    <select class="form-select" name="status" aria-label="Default select example">
                      <option value="{{$row->status}}" selected>{{$row->status}}</option>
                      <option value="used">used</option>
                      <option value="not used">not used</option>
                    </select>
                  </div>

                <div class="form-group">
                    <label for="expired date">expired date</label>
                    <input type="date" class="form-control" id="expired_date" value="{{$row->expired_date}}" name="expired_date" placeholder="expired_date" required>
                  </div>
                <hr>
                <div class="row mt-20">
                  <div class="col-sm-12">
                      <a class="btn btn-success" href="{{url('admin/draw')}}">Back</a>
                    <button type="submit" class="btn btn-primary">Edit</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
    </div>

    @push('js')

    <script>
      $(document).ready(function(){
        $("#prize_id").prop("disabled", true);
        $('body').on("change","#type",function(){
          var id = $(this).val();

          if(id == 'presentase'){
            $("#prize_id").prop("disabled", true);
          }else{
            $("#prize_id").prop("disabled", false);
          }
        });
      });
        
      </script>
    @endpush

@endsection