<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class SpinMember extends Model
{
    use HasFactory;
    protected $table = 'spin_member';

    protected $fillable = [
        'id',
        'username',
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinMember::orderBy('created_at','asc')->get();

        return $data;
    }

    public static function insertData($request){
        $data = SpinMember::create([
            'id'        => (string) Str::uuid(),
            'username'  => $request->username,
        ]);

        return $data;
    }

    public static function updateData($request){
        $data = SpinMember::where('id',$request->id)->update([
            'username'  => $request->username
        ]);

        return $data;
    }

    public static function detailData($id){
        $data = SpinMember::where('id',$id)->first();

        return $data;
    }
}
