<?php
namespace App\Helpers;

use Carbon\Carbon;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Http;
use Image;
 
use Illuminate\Support\Facades\DB;
use App\Models\Wheel\SpinContent;
use App\Models\Wheel\SpinDraw;
use App\Models\Wheel\SpinFaq;
use App\Models\Wheel\SpinHistory;
use App\Models\Wheel\SpinPrize;
use App\Models\Wheel\SpinVoucher;
 
class Fibonanci {

    //FUNCTION PRESENTASEEEE

    public static function presentase() {
        $pick = rand(0,10000);
                   // random number in the range [0, 10000).

        // https://stackoverflow.com/questions/30253794/lottery-algorithm-php-math-seems-good-but-is-the-function-valid
    
        if ($pick < 1000){

            $data = DB::table('spin_prize')
                    ->where('presentase','>',15)
                    ->inRandomOrder()
                    ->limit(1)
                    ->get();
            
        }elseif ($pick > 1000  and $pick < 1100){
            $data = DB::table('spin_prize')
                    ->where('presentase','>',10)
                    ->inRandomOrder()
                    ->limit(1)
                    ->get();
            

        } elseif ($pick == 1110){

            $data = DB::table('spin_prize')
                    ->where('presentase','>',1)
                    ->inRandomOrder()
                    ->limit(1)
                    ->get();
            
        }else{
            $data = DB::table('spin_prize')
                    ->where('status','lose')
                    ->inRandomOrder()
                    ->limit(1)
                    ->get();
            
        }

        $result = $data[0];

        return [
            "random"            => $pick,
            "id"                => $result->id,
            "label"             => $result->label,
            "status"            => $result->status,
            "presentase"        => $result->presentase,
            "sorter"            => $result->sorter,
        ];
    }

    //FUNCTION ROTATION

    public static function wheel_rotation($prize_id){

        $prize = SpinPrize::where('id',$prize_id)->first();

        $total = SpinPrize::count();

        $pie = 360 / $total;

        if($prize->sorter == 1){

            $rotation = Self::rumus_rotasi_start();
        }else{
            $rumus = 360 - ( ( $prize->sorter - 1 ) * $pie );
            $rotation = Self::rumus_rotasi_start() + $rumus ;
        }

        return $rotation;

    }

    public static function rumus_rotasi_start(){
        // (360/total_prize)*(total_prize - 1) - (360/total_prize)
        $total = SpinPrize::count();


        // MENGHITUNG NILAI 0 PUTARAN POSISI START
        $start = (360/$total)*($total - 1) - (360/$total);

        //MENGHITUNG KELIPATAN

        // $putaran = $start + (360 * 10);
        $putaran = (360 - 90) + (360 * 100);

        return $putaran;
    }


    //FUNCTION CONTENT

    public static function content(){
        $content = DB::table('spin_content')->where('status','active')->first();

        if($content){

        if($content->wheel){
            $wheel = url('storage/'.$content->wheel);
        }else{
            $wheel = url('default/wheel.png');
        }

        if($content->outwheel){
            $outwheel = url('storage/'.$content->outwheel);
        }else{
            $outwheel = url('default/outwheel.png');
        }

        if($content->logo){
            $logo = url('storage/'.$content->logo);
        }else{
            $logo = url('default/logo.png');
        }

        if($content->name){
            $name = $content->name;
        }else{
            $name = 'Spin Wheel';
        }

        if($content->background){
            $background = url('storage/'.$content->background);
        }else{
            $background = url('default/home.png');
        }

        if($content->favicon){
            $favicon = url('storage/'.$content->favicon);
        }else{
            $favicon = url('default/favicon.ico');
        }

        if($content->music){
            $music = url('storage/'.$content->music);
        }else{
            $music = url('default/home.mp3');
        }

        if($content->music_win){
            $music_win = url('storage/'.$content->music_win);
        }else{
            $music_win = url('default/win.mp3');
        }

        if($content->music_lose){
            $music_lose = url('storage/'.$content->music_lose);
        }else{
            $music_lose = url('default/lose.mp3');
        }

        if($content->music_spin){
            $music_spin = url('storage/'.$content->music_spin);
        }else{
            $music_spin = url('default/spin.mp3');
        }



        return[
            "wheel"=>$wheel,
            "outwheel"=>$outwheel,
            "logo"=>$logo,
            "name"=>$name,
            "background"=>$background,
            "favicon"=>$favicon,
            "music"=>$music,
            "music_win"=>$music_win,
            "music_lose"=>$music_lose,
            "music_spin"=>$music_spin,

        ];
        }else{
            return[
                "wheel"=>url('default/wheel.png'),
                "outwheel"=>url('default/outwheel.png'),
                "logo"=>url('default/logo.png'),
                "name"=>'spin wheel',
                "background"=>url('default/home.png'),
                "favicon"=>url('default/favicon.ico'),
                "music"=>url('default/home.mp3'),
                "music_win"=>url('default/win.mp3'),
                "music_lose"=>url('default/lose.mp3'),
                "music_spin"=>url('default/spin.mp3'),
            ];
        }

    }

    //FUNCTION RUBAH NAMA ADA *****

    public static function replace_last_character($string) {
        $arr_split = str_split($string);
        $jum_str = strlen($string);//bisa juga dengan count($arr_split)
        
        $replace_with = '*';
        $replace_start = $jum_str - 3;
        
        if ($replace_start < 0) {
            return $string;
        }
        
        $str_fmt = '';
        for ($i=0;$i<$jum_str;$i++) {
            if ($i < $replace_start) {
                $str_fmt .= $arr_split[$i];
            } else {
                $str_fmt .= $replace_with;
            }
        }
        
        return $str_fmt;
    }

    public static function randomName() {
        $firstname = array(
            'Johnathon',
            'Anthony',
            'Erasmo',
            'Raleigh',
            'Nancie',
            'Tama',
            'Camellia',
            'Augustine',
            'Christeen',
            'Luz',
            'Diego',
            'Lyndia',
            'Thomas',
            'Georgianna',
            'Leigha',
            'Alejandro',
            'Marquis',
            'Joan',
            'Stephania',
            'Elroy',
            'Zonia',
            'Buffy',
            'Sharie',
            'Blythe',
            'Gaylene',
            'Elida',
            'Randy',
            'Margarete',
            'Margarett',
            'Dion',
            'Tomi',
            'Arden',
            'Clora',
            'Laine',
            'Becki',
            'Margherita',
            'Bong',
            'Jeanice',
            'Qiana',
            'Lawanda',
            'Rebecka',
            'Maribel',
            'Tami',
            'Yuri',
            'Michele',
            'Rubi',
            'Larisa',
            'Lloyd',
            'Tyisha',
            'Samatha',
        );
    
        $lastname = array(
            'Mischke',
            'Serna',
            'Pingree',
            'Mcnaught',
            'Pepper',
            'Schildgen',
            'Mongold',
            'Wrona',
            'Geddes',
            'Lanz',
            'Fetzer',
            'Schroeder',
            'Block',
            'Mayoral',
            'Fleishman',
            'Roberie',
            'Latson',
            'Lupo',
            'Motsinger',
            'Drews',
            'Coby',
            'Redner',
            'Culton',
            'Howe',
            'Stoval',
            'Michaud',
            'Mote',
            'Menjivar',
            'Wiers',
            'Paris',
            'Grisby',
            'Noren',
            'Damron',
            'Kazmierczak',
            'Haslett',
            'Guillemette',
            'Buresh',
            'Center',
            'Kucera',
            'Catt',
            'Badon',
            'Grumbles',
            'Antes',
            'Byron',
            'Volkman',
            'Klemp',
            'Pekar',
            'Pecora',
            'Schewe',
            'Ramage',
        );
    
        $name = $firstname[rand ( 0 , count($firstname) -1)];
        $name .= ' ';
        $name .= $lastname[rand ( 0 , count($lastname) -1)];
    
        return $name;
    }


    public static function status($status){
        
        if($status == 'active'){
            return '<div class="badge badge-opacity-success">'.$status.'</div>';
        }
        
        if($status == 'not active'){
            return '<div class="badge badge-opacity-warning">'.$status.'</div>';
        }
        
        if($status == 'used'){
            return '<div class="badge badge-opacity-success">'.$status.'</div>';
        }
        
        if($status == 'not used'){
            return '<div class="badge badge-opacity-warning">'.$status.'</div>';
        }
        
        if($status == 'select prize'){
            return '<div class="badge badge-opacity-primary">'.$status.'</div>';
        }
        
        if($status == 'win'){
            return '<div class="badge badge-opacity-success">'.$status.'</div>';
        }
        
        
        if($status == 'lose'){
            return '<div class="badge badge-opacity-warning">'.$status.'</div>';
        }else{
            return '<div class="badge badge-opacity-warning">'.$status.'</div>';
        }
    }
   
}